// background.js

// এক্সটেনশন ইনস্টল হওয়ার সময় কনটেক্সট মেনু তৈরি করা
chrome.runtime.onInstalled.addListener(() => {
  chrome.contextMenus.create({
    id: "addAutofillField",
    title: "এই ফিল্ডটি অটোফিল প্রোফাইলে যোগ করুন",
    contexts: ["editable"] // শুধুমাত্র ইনপুট, টেক্সটএরিয়া ইত্যাদির জন্য দেখানো হবে
  });
});

// কনটেক্সট মেনুতে ক্লিক করা হলে এই ফাংশনটি কল হবে
chrome.contextMenus.onClicked.addListener((info, tab) => {
  if (info.menuItemId === "addAutofillField" && tab && tab.id) {
    chrome.scripting.executeScript({
      target: { tabId: tab.id },
      func: getClickedElementDetails // এই ফাংশনটি পেজের কনটেক্সটে রান হবে
    }, (injectionResults) => {
      if (chrome.runtime.lastError) {
        console.error("Error injecting script or getting element details:", chrome.runtime.lastError.message);
        return;
      }
      if (!injectionResults || !injectionResults[0] || !injectionResults[0].result) {
        console.error("Error getting element details: No result from injection.");
        // একটি নোটিফিকেশন দেখানো যেতে পারে যে কোনো তথ্য পাওয়া যায়নি
        chrome.notifications.create({
            type: 'basic',
            iconUrl: 'icons/icon48.png',
            title: 'অটোফিল এক্সটেনশন',
            message: 'ক্লিক করা ফিল্ড থেকে তথ্য সংগ্রহ করা যায়নি।',
            priority: 1
        });
        return;
      }

      const details = injectionResults[0].result;
      if (details.selector) {
        // তথ্যগুলো লোকাল স্টোরেজে সেভ করা হচ্ছে যাতে পপআপ এটি ব্যবহার করতে পারে
        chrome.storage.local.set({
          pendingField: {
            selector: details.selector,
            value: details.value
          }
        }, () => {
          if (chrome.runtime.lastError) {
            console.error("Error saving pending field to local storage:", chrome.runtime.lastError.message);
          } else {
            console.log("Field details stored for popup:", details);
            // ব্যবহারকারীকে জানানো যেতে পারে যে ফিল্ডটি যোগ করার জন্য প্রস্তুত
            // chrome.notifications.create({
            //     type: 'basic',
            //     iconUrl: 'icons/icon48.png',
            //     title: 'অটোফিল এক্সটেনশন',
            //     message: `"${details.selector}" ফিল্ডটি যোগ করার জন্য প্রস্তুত। পপআপ খুলে সেভ করুন।`,
            //     priority: 1
            // });
          }
        });
      } else {
        console.log("Could not determine a suitable selector for the clicked field.");
        // ব্যবহারকারীকে নোটিফিকেশনের মাধ্যমে জানানো
        chrome.notifications.create({
            type: 'basic',
            iconUrl: 'icons/icon48.png', // এই আইকনটি আপনার এক্সটেনশনে থাকতে হবে
            title: 'অটোফিল এক্সটেনশন',
            message: 'এই ফিল্ডের জন্য উপযুক্ত সিলেক্টর (ID বা Name) পাওয়া যায়নি।',
            priority: 1
        });
      }
    });
  }
});

// এই ফাংশনটি ওয়েবসাইটের পেজের কনটেক্সটে রান হবে (executeScript এর মাধ্যমে)
function getClickedElementDetails() {
  const el = document.activeElement; // যে এলিমেন্টে রাইট-ক্লিক করা হয়েছে
  let selector = null;
  if (el && (el.tagName === 'INPUT' || el.tagName === 'TEXTAREA' || el.tagName === 'SELECT')) {
    if (el.id) {
      selector = `#${el.id}`;
    } else if (el.name) {
      // নামের জন্য আরও সুনির্দিষ্ট সিলেক্টর তৈরি করা হচ্ছে
      selector = `${el.tagName.toLowerCase()}[name="${el.name}"]`;
    }
    // প্রয়োজনে আরও জটিল সিলেক্টর জেনারেট করার লজিক এখানে যোগ করা যেতে পারে
  }
  return { selector: selector, value: el ? el.value : '' };
}


// এই ফাংশনটি পেইজের কনটেক্সটে রান হবে (executeScript এর মাধ্যমে ডেটপিকারের জন্য)
// background.js


function setDatepickerValueInPage(selector, value) {
    const el = document.querySelector(selector);
    if (!el) {
        console.warn('AutoFill (Page Context - executeScript from BG): Element ' + selector + ' not found for datepicker.');
        return false;
    }

    const $el = window.jQuery ? window.jQuery(el) : null; // jQuery অবজেক্ট (যদি jQuery থাকে)

    if ($el && typeof $el.datepicker === 'function' && $el.data('datepicker')) {
        try {
            const dateParts = value.split('/');
            let jsDateObject;
            let operationSuccess = false; // ট্র্যাক করবে ডেট সেট হয়েছে কিনা

            if (dateParts.length === 3) { // DD/MM/YYYY
                const day = parseInt(dateParts[0], 10);
                const month = parseInt(dateParts[1], 10) - 1;
                const year = parseInt(dateParts[2], 10);
                jsDateObject = new Date(year, month, day);
            } else if (dateParts.length === 2 && el.id === 'BillingStartDate' && value.match(/^\d{1,2}\/\d{4}$/)) { // MM/YYYY
                el.value = value;
                operationSuccess = true;
            } else {
                el.value = value; // ফলব্যাক হিসেবে সরাসরি ভ্যালু সেট
                operationSuccess = true; // সরাসরি ভ্যালু সেট করাকেও আপাতত সফল ধরছি
            }

            if (jsDateObject && !isNaN(jsDateObject.getTime())) {
                $el.datepicker('setDate', jsDateObject);
                operationSuccess = true;
            } else if (jsDateObject === undefined && !operationSuccess) { // যদি jsDateObject তৈরি না হয় এবংBillingStartDate-এর বিশেষ ক্ষেত্র না হয়
                 $el.datepicker('setDate', value); // স্ট্রিং দিয়ে চেষ্টা
                 operationSuccess = true;
            }

            // ইভেন্ট ডিসপ্যাচ করা
            ['input', 'change', 'blur'].forEach(eventType => {
                if (el.dispatchEvent) el.dispatchEvent(new Event(eventType, { bubbles: true, cancelable: true }));
            });

            // ডেটপিকার পপআপ বন্ধ করার চেষ্টা
            // $el.datepicker('hide'); // এই লাইনটি যোগ করা হয়েছে

            // কিছু ডেটপিকার 'hide' এর পর blur ইভেন্ট চায়, অথবা focus অন্য কোথাও সরাতে হয়
            // el.blur(); // blur কল করা হচ্ছে
            // অথবা, একটি ছোট ডিলে দিয়ে hide কল করা যেতে পারে
            setTimeout(() => {
                if (typeof $el.datepicker === 'function' && $el.data('datepicker')) { // নিশ্চিত করা হচ্ছে যে ডেটপিকার এখনও আছে
                    $el.datepicker('hide');
                }
            }, 100); // 100ms ডিলে

            return operationSuccess; // অথবা শুধুমাত্র true যদি কোনো ভ্যালু সেট হয়

        } catch (e) {
            console.error('AutoFill (Page Context - executeScript from BG): Error setting/hiding date using Bootstrap datepicker API for "' + selector + '". Error:', e);
            if (!el.value) el.value = value; // যদি try ব্লকে ভ্যালু সেট না হয়ে থাকে
            ['input', 'change', 'blur'].forEach(eventType => {
                if (el.dispatchEvent) el.dispatchEvent(new Event(eventType, { bubbles: true, cancelable: true }));
            });
            return false;
        }
    } else { // যদি jQuery বা ডেটপিকার না থাকে
        el.value = value;
        ['input', 'change', 'blur'].forEach(eventType => {
            if (el.dispatchEvent) el.dispatchEvent(new Event(eventType, { bubbles: true, cancelable: true }));
        });
        return true;
    }
}

// কন্টেন্ট স্ক্রিপ্ট থেকে আসা মেসেজ শোনার জন্য লিসেনার
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    // কন্টেন্ট স্ক্রিপ্টকে তার নিজের ট্যাব আইডি পাঠানোর জন্য
    if (request.type === "GET_TAB_ID" || request.type === "GET_TAB_ID_FOR_CONTENT_SCRIPT_CONTEXT") {
        if (sender.tab && sender.tab.id) {
            sendResponse({ tabId: sender.tab.id });
        } else {
            // এই পরিস্থিতি আসা উচিত নয় যদি মেসেজ কন্টেন্ট স্ক্রিপ্ট থেকে আসে
            console.error(`${request.type}: sender.tab.id not found. Sender:`, sender);
            sendResponse({}); // একটি খালি অবজেক্ট পাঠানো ভালো, undefined এর চেয়ে
        }
        return true; // অ্যাসিঙ্ক্রোনাস রেসপন্সের জন্য এটি অত্যাবশ্যক
    }
    // ডেটপিকার ফিল্ড পূরণ করার জন্য কন্টেন্ট স্ক্রিপ্ট থেকে আসা মেসেজ
    else if (request.type === "FILL_DATEPICKER_FIELD") {
        const { payload } = request;
        // payload ভ্যালিডেশন
        if (!payload || payload.tabId === undefined || !payload.selector || payload.value === undefined) {
            console.error("FILL_DATEPICKER_FIELD: Invalid payload received.", payload);
            sendResponse({ success: false, error: "Invalid payload" });
            return true; // অ্যাসিঙ্ক্রোনাস না হলেও, সব sendResponse পাথ true রিটার্ন করা ভালো
        }

        chrome.scripting.executeScript({
            target: { tabId: payload.tabId },
            func: setDatepickerValueInPage, // উপরে ডিফাইন করা ফাংশন
            args: [payload.selector, payload.value], // ফাংশনে পাস করার জন্য আর্গুমেন্ট
            world: 'MAIN' // পেজের প্রধান জাভাস্ক্রিপ্ট পরিবেশে এক্সিকিউট করা
        }, (injectionResults) => {
            if (chrome.runtime.lastError) {
                console.error("Error injecting script for datepicker from background:", chrome.runtime.lastError.message);
                sendResponse({ success: false, error: chrome.runtime.lastError.message });
            } else if (injectionResults && injectionResults[0] && injectionResults[0].result !== undefined) {
                // setDatepickerValueInPage থেকে যা রিটার্ন আসবে (true/false)
                sendResponse({ success: injectionResults[0].result });
            } else {
                // যদি কোনো কারণে injectionResults বা result না থাকে
                console.warn("Datepicker injection from background had no explicit result. Assuming partial success or best-effort.");
                sendResponse({ success: true }); // ফলব্যাক হিসেবে true পাঠানো হচ্ছে, অথবা false যদি কঠোর চেকিং চান
            }
        });
        return true; // অ্যাসিঙ্ক্রোনাস রেসপন্সের জন্য এটি অত্যাবশ্যক
    }
    // এখানে অন্যান্য মেসেজ টাইপের জন্য আরও 'else if' ব্লক যোগ করা যেতে পারে

    // যদি কোনো মেসেজ টাইপ ম্যাচ না করে
    // console.log("Unrecognized message received in background.js:", request);
    // sendResponse({}); // একটি ডিফল্ট রেসপন্স পাঠানো যেতে পারে
    // return true; // যদি ডিফল্ট রেসপন্সও অ্যাসিঙ্ক্রোনাস হতে পারে
});